<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see \Composer\InstalledVersions::getRootPackage()} instead. The
     *             equivalent expression for this constant's contents is
     *             `\Composer\InstalledVersions::getRootPackage()['name']`.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = '__root__';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'composer/package-versions-deprecated' => '1.10.99.1@68c9b502036e820c33445ff4d174327f6bb87486',
  'doctrine/annotations' => '1.10.4@bfe91e31984e2ba76df1c1339681770401ec262f',
  'doctrine/cache' => '1.10.2@13e3381b25847283a91948d04640543941309727',
  'doctrine/collections' => '1.6.7@55f8b799269a1a472457bd1a41b4f379d4cfba4a',
  'doctrine/common' => '3.0.2@a3c6479858989e242a2465972b4f7a8642baf0d4',
  'doctrine/dbal' => '2.10.4@47433196b6390d14409a33885ee42b6208160643',
  'doctrine/doctrine-bundle' => '2.1.2@f5153089993e1230f5d8acbd8e126014d5a63e17',
  'doctrine/doctrine-migrations-bundle' => '2.2.0@5efa29df768abaafe29b34e73dac68efbedcaa4d',
  'doctrine/event-manager' => '1.1.1@41370af6a30faa9dc0368c4a6814d596e81aba7f',
  'doctrine/inflector' => '1.4.3@4650c8b30c753a76bf44fb2ed00117d6f367490c',
  'doctrine/instantiator' => '1.3.1@f350df0268e904597e3bd9c4685c53e0e333feea',
  'doctrine/lexer' => '1.2.1@e864bbf5904cb8f5bb334f99209b48018522f042',
  'doctrine/migrations' => '2.2.1@a3987131febeb0e9acb3c47ab0df0af004588934',
  'doctrine/orm' => 'v2.7.3@d95e03ba660d50d785a9925f41927fef0ee553cf',
  'doctrine/persistence' => '2.0.0@1dee036f22cd5dc0bc12132f1d1c38415907be55',
  'doctrine/reflection' => '1.2.1@55e71912dfcd824b2fdd16f2d9afe15684cfce79',
  'doctrine/sql-formatter' => '1.1.1@56070bebac6e77230ed7d306ad13528e60732871',
  'egulias/email-validator' => '2.1.22@68e418ec08fbfc6f58f6fd2eea70ca8efc8cc7d5',
  'fzaninotto/faker' => 'v1.9.1@fc10d778e4b84d5bd315dad194661e091d307c6f',
  'monolog/monolog' => '1.25.5@1817faadd1846cd08be9a49e905dc68823bc38c0',
  'ocramius/proxy-manager' => '2.2.3@4d154742e31c35137d5374c998e8f86b54db2e2f',
  'phpdocumentor/reflection-common' => '2.2.0@1d01c49d4ed62f25aa84a747ad35d5a16924662b',
  'phpdocumentor/reflection-docblock' => '4.3.4@da3fd972d6bafd628114f7e7e036f45944b62e9c',
  'phpdocumentor/type-resolver' => '1.4.0@6a467b8989322d92aa1c8bf2bebcc6e5c2ba55c0',
  'psr/cache' => '1.0.1@d11b50ad223250cf17b86e38383413f5a6764bf8',
  'psr/container' => '1.0.0@b7ce3b176482dbbc1245ebf52b181af44c2cf55f',
  'psr/link' => '1.0.0@eea8e8662d5cd3ae4517c9b864493f59fca95562',
  'psr/log' => '1.1.3@0f73288fd15629204f9d42b7055f72dacbe811fc',
  'sensio/framework-extra-bundle' => 'v5.6.1@430d14c01836b77c28092883d195a43ce413ee32',
  'symfony/asset' => 'v4.4.14@9b446eb7c16347088663dc18d38fb0f3b536b7e2',
  'symfony/cache' => 'v4.4.14@f84468fb77d2d9599bdfb648aeaad96f24d8bce9',
  'symfony/cache-contracts' => 'v2.2.0@8034ca0b61d4dd967f3698aaa1da2507b631d0cb',
  'symfony/config' => 'v4.4.14@3880541ff96d2e9a113f355d8c6891489c63cf56',
  'symfony/console' => 'v4.4.14@90933b39c7b312fc3ceaa1ddeac7eb48cb953124',
  'symfony/debug' => 'v4.4.14@726b85e69342e767d60e3853b98559a68ff74183',
  'symfony/dependency-injection' => 'v4.4.14@89274c8847dff2ed703e481843eb9159ca25cc6e',
  'symfony/doctrine-bridge' => 'v4.4.14@39cfb22983b7d6ef4fa0326611518a4f3de51446',
  'symfony/dotenv' => 'v4.4.14@f17675595fd7527c57d11bd3d733eb5d41600128',
  'symfony/error-handler' => 'v4.4.14@5a6feca7a384015a09e14265c35ee0bd6f54b2ed',
  'symfony/event-dispatcher' => 'v4.4.14@e17bb5e0663dc725f7cdcafc932132735b4725cd',
  'symfony/event-dispatcher-contracts' => 'v1.1.9@84e23fdcd2517bf37aecbd16967e83f0caee25a7',
  'symfony/expression-language' => 'v4.4.14@54b118a1c91991b90e67919146db66093def1bf9',
  'symfony/filesystem' => 'v4.4.14@0d386979828c15d37ff936bf9bae2ecbfa36d7dc',
  'symfony/finder' => 'v4.4.14@5ef0f6c609c1a36f723880dfe78301199bc96868',
  'symfony/flex' => 'v1.9.4@115e67f76ba95d70946a6e0b15d4578bf04927c3',
  'symfony/form' => 'v4.4.14@1988f547f5a91f91ccd6b37c47ab8f45c9826f59',
  'symfony/framework-bundle' => 'v4.4.14@702d50f06d1aef4cab90a5bf85eb0721377b7398',
  'symfony/http-client' => 'v4.4.14@00a61220bb0439ce71d48d375b15be7a23f9ea98',
  'symfony/http-client-contracts' => 'v2.2.0@3a5d0fe7908daaa23e3dbf4cee3ba4bfbb19fdd3',
  'symfony/http-foundation' => 'v4.4.14@ff509ca7a73641bdbd7b56169a9004e64a58451d',
  'symfony/http-kernel' => 'v4.4.14@e3eac6daeb0c65965a6201bd2de9564a802fe0a9',
  'symfony/inflector' => 'v4.4.14@3330be44724db42f0aa493002ae63f5d29f8d5f7',
  'symfony/intl' => 'v4.4.14@0da1f7f08072ddb9185b02ce30ce098fa61f4042',
  'symfony/mailer' => 'v4.4.14@c1018952b49058802c2aa1ea831935e996b7f5d3',
  'symfony/mime' => 'v4.4.14@42df2507eb8e6cd9795f51c99dd52bab543a918f',
  'symfony/monolog-bridge' => 'v4.4.14@cabcfc538330cdc502fdc19d9095994bd4a91c80',
  'symfony/monolog-bundle' => 'v3.5.0@dd80460fcfe1fa2050a7103ad818e9d0686ce6fd',
  'symfony/options-resolver' => 'v4.4.14@02b120a79ff06b779819f1594a300226bfc75105',
  'symfony/polyfill-intl-icu' => 'v1.18.1@4e45a6e39041a9cc78835b11abc47874ae302a55',
  'symfony/polyfill-intl-idn' => 'v1.18.1@5dcab1bc7146cf8c1beaa4502a3d9be344334251',
  'symfony/polyfill-intl-normalizer' => 'v1.18.1@37078a8dd4a2a1e9ab0231af7c6cb671b2ed5a7e',
  'symfony/polyfill-mbstring' => 'v1.18.1@a6977d63bf9a0ad4c65cd352709e230876f9904a',
  'symfony/polyfill-php72' => 'v1.18.1@639447d008615574653fb3bc60d1986d7172eaae',
  'symfony/polyfill-php73' => 'v1.18.1@fffa1a52a023e782cdcc221d781fe1ec8f87fcca',
  'symfony/polyfill-php80' => 'v1.18.1@d87d5766cbf48d72388a9f6b85f280c8ad51f981',
  'symfony/process' => 'v4.4.14@9b887acc522935f77555ae8813495958c7771ba7',
  'symfony/property-access' => 'v4.4.14@ecc35239f0f665fd7a8e3a2ecaad7e4ee2668ab6',
  'symfony/property-info' => 'v4.4.14@387c5823e37f14271a499d1b9844c2009cb79d44',
  'symfony/routing' => 'v4.4.14@8db77d97152f55f0df5158cc0a877ad8e16099ac',
  'symfony/security-bundle' => 'v4.4.14@274b0eb10dfc9067175cb4d1bcc68f8b37ebee14',
  'symfony/security-core' => 'v4.4.14@637ba4c57a7e44426e18763331b7b154d52b81a4',
  'symfony/security-csrf' => 'v4.4.14@59bc56de929b1e1d2cd41c22874f8f57863f0aff',
  'symfony/security-guard' => 'v4.4.14@95b7f702c4f07c44504a81c69ef07036e68b96b9',
  'symfony/security-http' => 'v4.4.14@eddcd6b7372d430a47091fa5e5d733785b5a582b',
  'symfony/serializer' => 'v4.4.14@c4bc95bf668be70d57eec904ac222fb4b694e73e',
  'symfony/service-contracts' => 'v2.2.0@d15da7ba4957ffb8f1747218be9e1a121fd298a1',
  'symfony/stopwatch' => 'v4.4.14@6f89e19772cf61b3c65bab329fe0e318259fbd91',
  'symfony/translation' => 'v4.4.14@0b8c4bb49b05b11d2b9dd1732f26049b08d96884',
  'symfony/translation-contracts' => 'v2.2.0@77ce1c3627c9f39643acd9af086631f842c50c4d',
  'symfony/twig-bridge' => 'v4.4.14@ac5de06ef28f0638bd87d8fcf515715232db34d2',
  'symfony/twig-bundle' => 'v4.4.14@1522d77d5442e4156ab78f07901272185c670d44',
  'symfony/validator' => 'v4.4.14@8da71f775b7e1ffeed784d27f526527bb8e9504b',
  'symfony/var-dumper' => 'v4.4.14@0dc22bdf9d1197467bb04d505355180b6f20bcca',
  'symfony/var-exporter' => 'v4.4.14@bb6c505d1492bf55534184c0a38826bda529e5e2',
  'symfony/web-link' => 'v4.4.14@b862a104ef3a233b6f12fdbf6b57113308af79ff',
  'symfony/yaml' => 'v4.4.14@c7885964b1eceb70b0981556d0a9b01d2d97c8d1',
  'twig/extra-bundle' => 'v3.0.5@a7c5799cf742ab0827f5d32df37528ee8bf5a233',
  'twig/twig' => 'v3.0.5@9b76b1535483cdf4edf01bb787b0217b62bd68a5',
  'webmozart/assert' => '1.9.1@bafc69caeb4d49c39fd0779086c03a3738cbb389',
  'zendframework/zend-code' => '3.4.1@268040548f92c2bfcba164421c1add2ba43abaaa',
  'zendframework/zend-eventmanager' => '3.2.1@a5e2583a211f73604691586b8406ff7296a946dd',
  'doctrine/data-fixtures' => '1.4.4@16a03fadb5473f49aad70384002dfd5012fe680e',
  'doctrine/doctrine-fixtures-bundle' => '3.3.2@a2179f447425d9e784fb9bc224e533a0ab083b98',
  'nikic/php-parser' => 'v4.10.2@658f1be311a230e0907f5dfe0213742aff0596de',
  'symfony/browser-kit' => 'v4.4.14@4012fac896bf5c1ac435d8c5d98fa2163241dbcc',
  'symfony/css-selector' => 'v4.4.14@bf17dc9f6ce144e41f786c32435feea4d8e11dcc',
  'symfony/debug-bundle' => 'v4.4.14@12a020d14b4f6f3a5cfb46cd83836b78be036210',
  'symfony/dom-crawler' => 'v4.4.14@69690afed0881bb53f85dc1637e6b85416a1cd33',
  'symfony/maker-bundle' => 'v1.21.1@da629093c7bf9abd9a6a0f232a43bbb1b88de68d',
  'symfony/phpunit-bridge' => 'v5.1.6@6753ea4cb2dab705e819b1ddd8833a5c98338650',
  'symfony/web-profiler-bundle' => 'v4.4.14@f3b967b34b1db5d3285c415fbe5ce2b9299e6cd6',
  'symfony/web-server-bundle' => 'v4.4.14@1dedc2a07a15644ee82b82e87d629a35789532b0',
  'paragonie/random_compat' => '2.*@929da9611115f91d08d9a7029422c03e7c7bedba',
  'symfony/polyfill-ctype' => '*@929da9611115f91d08d9a7029422c03e7c7bedba',
  'symfony/polyfill-iconv' => '*@929da9611115f91d08d9a7029422c03e7c7bedba',
  'symfony/polyfill-php71' => '*@929da9611115f91d08d9a7029422c03e7c7bedba',
  'symfony/polyfill-php70' => '*@929da9611115f91d08d9a7029422c03e7c7bedba',
  'symfony/polyfill-php56' => '*@929da9611115f91d08d9a7029422c03e7c7bedba',
  '__root__' => 'dev-master@929da9611115f91d08d9a7029422c03e7c7bedba',
);

    private function __construct()
    {
        class_exists(InstalledVersions::class);
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (class_exists(InstalledVersions::class, false)) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }
}
